USE [AdventureWorks2016]

GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE [name] = 'IX_SalesOrderHeader_OrderDate')
	CREATE NONCLUSTERED INDEX [IX_SalesOrderHeader_OrderDate] ON [Sales].[SalesOrderHeader]
	(
		[OrderDate] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)

GO

--USE [AdventureWorks2016]
--GO

--/****** Object:  Table [Person].[EmailAddress]    Script Date: 4/6/2016 8:12:31 AM ******/
--SET ANSI_NULLS ON
--GO

--SET QUOTED_IDENTIFIER ON
--GO

--IF OBJECT_ID('dbo.EmailAddress') IS NULL 
--  BEGIN 

--	CREATE TABLE dbo.[EmailAddress](
--		[BusinessEntityID] [int] NOT NULL,
--		[EmailAddressID] [int] NOT NULL,
--		[EmailAddress] [varchar](50) NULL,
--		[rowguid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_EmailAddress_rowguid]  DEFAULT (newid()),
--		[ModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_EmailAddress_ModifiedDate]  DEFAULT (getdate()),
--	 CONSTRAINT [PK_EmailAddress_BusinessEntityID_EmailAddressID] PRIMARY KEY CLUSTERED 
--	(
--		[BusinessEntityID] ASC,
--		[EmailAddressID] ASC
--	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
--	) ON [PRIMARY]

--	CREATE NONCLUSTERED INDEX [dbo_EmailAddress_EmailAddress] ON [dbo].[EmailAddress]
--	(
--		[EmailAddress] ASC
--	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON)


--	INSERT dbo.EmailAddress
--	SELECT * FROM Person.EmailAddress


--END 
